
#import <Foundation/Foundation.h>


typedef enum _MCBasicObjectType {
    MCUnknowObjectType			= -1,
    NSObjectType				= 0,
    MCObjectType				= 2,
    MCPersistentObjectType		= 3
} MCBasicObjectType;

typedef enum _MCBooleanOperator {
    MCBooleanAndOperator		= 1,
    MCBooleanOrOperator
} MCBooleanOperator;

typedef enum _MCLineEndingType {
	MCLineEndingTypeLF   = 1,
	MCLineEndingTypeCR   = 2,
	MCLineEndingTypeCRLF = 3
} MCLineEndingType;

// Macros

// usage
// if (boo < 0)
// 	MCINVALIDARGUMENT("boo");

#define MCINVALIDARGUMENT(argname)                                              \
    do {                                                                        \
		[NSException raise:@"MCInvalidArgumentException" format:@"Invalid value for %s - Class:%@ Selector:%@ File:%s Line:%i", argname, NSStringFromClass([self class]), NSStringFromSelector(_cmd), __FILE__, __LINE__];          \
    } while (NO)

#define MCUNIMPLEMENTEDMETHOD                                              \
    do {                                                                        \
		[NSException raise:@"MCUnimplementedMethodException" format:@"Method not implemented - may require subclassers to implement - Class:%@ Selector:%@ File:%s Line:%i", NSStringFromClass([self class]), NSStringFromSelector(_cmd), __FILE__, __LINE__];          \
    } while (NO)

#define MCLOGLOCATION  NSLog(@"Location -- Class:%@ Selector:%@ File:%s Line:%i", NSStringFromClass([self class]), NSStringFromSelector(_cmd), __FILE__, __LINE__)

#define MCPRECONDITION(expression)                                            \
do {                                                                        \
	if (!(expression))                                                      \
		MCINVALIDARGUMENT("PRECONDITION");    \
} while (NO)


#define MCValueIfPositive(x) (x>=0) ? x : 0

extern NSString *MCAlwaysOpenObjectEditorLikeNewObject;


FOUNDATION_EXPORT NSString *MCUserDefaultsDidChangeNotification;

// PowerWatcher Notifications
FOUNDATION_EXPORT NSString *MCSystemDidWake;
FOUNDATION_EXPORT NSString *MCSystemWillSleep;

FOUNDATION_EXPORT NSString *MCInvalidRelationshipTypeException;


//this is passed in the notification userInfo as the editor
extern NSString *MCEditor;
extern NSString *MCChangedAttributesSet;
extern NSString *MCAddedOrRemovedObject;


//Fired when editor finished changing. Self is the object in notification.
extern NSString *MCObjectDidChangeNotification;
extern NSString *MCObjectWillChangeNotification;
extern NSString *MCObjectContainerDidAddNotification;
extern NSString *MCObjectContainerDidRemoveNotification;

//Fired when bulk edit mode is not on, when anything on a given object has changed, even relationships
extern NSString *MCObjectDidModifyNotification;

// Fired when stuff gets linked by the linking context
extern NSString *MCDidLinkObjectsNotification;
// Fired when stuff gets unlinked by the linking context
extern NSString *MCDidUnlinkObjectsNotification;

// currrently used when objects have been changed remotely (i.e. in a database server)
// Observers are expected to update the UI. The object in the notification is the model
extern NSString *MCForceModelUpdateNotification;

extern NSString *MCDidDeleteObjectsNotification;
extern NSString *MCDidTrashObjectsNotification;
extern NSString *MCDidRestoreTrashedObjectsNotification;
extern NSString *MCDidPermanentlyDeleteTrashedObjectsNotification;

// Field Option Notifications
extern NSString *MCDidAddFieldOptionNotification;
extern NSString *MCDidModifyFieldOptionNotification;
extern NSString *MCDidDeleteFieldOptionNotification;

// Meta Data Store
extern NSString *MCMetaDataStoreModificationDate;

// Did Show Object(s) notification
extern NSString *MCDidShowObjectsNotification;

// Added Major Object notification
extern NSString *MCAddedMajorObjectNotification;

// Generic key for passing an array of objects around
extern NSString *MCObjectsKey;

extern NSString*  MCDocumentKey;
extern NSString*  MCWindowKey;
extern NSString*  MCObjectContextKey;
/**************************************

// EXCEPTIONS

***************************************/


extern NSString *MCGenericException; // akin to NSGenericException -- but we'll know it's in our code
extern NSString *MCCriticalException; // unable to do something important but won't corrupt data
extern NSString *MCFatalException; // something bad has happened -- MCApplication stops the app on this type of error ...








extern int BDControlAPIVersion;

/* Current version is 1.0.4 */
#define BDControlAPIVersionCurrent 0x01048000

/*

 The version number is a Mac OS 'vers' style version number.  Thus
 0x01002001 means "1.0.0d1".

 0x01 - version 1 (BCD)
 0x00 - version .0.0 (BCD)
 0x20 - development (0x20 = development, 0x40 = alpha, 0x60 = beta, 0x80 = final)
 0x01 - 1 (real hex byte)

 */


typedef enum _MCGroupBySorting {
    MCGroupByNoSort			= 0,
    MCGroupBySortAscending	= 1,
	MCGroupBySortDescending = 2
} MCGroupBySorting;

extern NSString *MCGroupByObjects;
extern NSString *MCGroupByIndex;
extern NSString *MCGroupByOther;

